import numpy as np
import matplotlib.pyplot as plt

# Define Phi in degrees and convert to radians
Phi_deg = np.arange(0, 361)
Phi = np.radians(Phi_deg)

# Parametric equations for the brachistochrone
X = Phi - np.sin(Phi)
Y = 1 - np.cos(Phi)

# Plot the result (replicates MATLAB Figure 10)
plt.figure(num=10)
plt.plot(X, Y)
plt.xlim([0, 7])   # To match the MATLAB axis
plt.ylim([0, 2])
plt.xlabel("X")
plt.ylabel("Y")
plt.title("Brachistochrone Curve")
plt.show()
