import numpy as np

# Constants
G = 6.6743e-11
M_e = 5.972e24
M_m = 7.34767309e22
M_s = 1.9891e30

# Radii
r_polar = 6356752
r_equator = 6376137
R_e = 6371000
print(f"r_polar = {r_polar}")
print(f"r_equator = {r_equator}")

# Radii of gyration
k_polar = np.sqrt((2/5) * r_equator**2)
k_equator = np.sqrt((1/5) * (r_polar**2 + r_equator**2))
print(f"k_polar = {k_polar:.4e}")
print(f"k_equator = {k_equator:.4e}")

# Mean orbital radius of Sun
a = 147.095e9
b = 152.100e9
R_sun = np.sqrt(a * b)
print(f"R_sun = {R_sun:.4e}")

# Moon orbital distance
R_moon = 3.84748e8

# Moments of inertia
I = M_e * k_polar**2
I_prime = M_e * k_equator**2

# Gravitational torques
Gam_Sun = (3/2) * G * (M_s / R_sun**3) * (I - I_prime)
Gam_Moon = (3/2) * G * (M_m / R_moon**3) * (I - I_prime)

# Time constants
one_day = 23 * 3600 + 56 * 60 + 4.091
one_year = 31557600
Omega = 2 * np.pi / one_year
print(f"one_day = {one_day:.4e}")
print(f"one_year = {int(one_year)}")
print(f"Omega = {Omega:.4e}")

phi_dot = 2 * np.pi / one_day
beta = phi_dot
print(f"phi_dot = {phi_dot:.4e}")

theta_Sun = np.radians(23.44)
theta_Moon = np.radians(5.145 + 23.44)

w_psi_Sun = np.cos(theta_Sun) * Gam_Sun / (I * beta)
w_psi_Moon = np.cos(theta_Moon) * Gam_Moon / (I * beta)
print(f"w_psi_Sun = {w_psi_Sun:.4e}")
print(f"w_psi_Moon = {w_psi_Moon:.4e}")

T_Sun = np.pi / w_psi_Sun
T_Moon = np.pi / w_psi_Moon
T_comb = np.pi / (w_psi_Sun + w_psi_Moon)
print(f"T_Sun = {T_Sun:.4e}")
print(f"T_Moon = {T_Moon:.4e}")
print(f"T_comb = {T_comb:.4e}")

ans_array = np.array([T_Sun, T_Moon, T_comb]) / one_year / 1e4
print("ans = 1.0e+04 *")
print(f"    {ans_array[0]:.4f}    {ans_array[1]:.4f}    {ans_array[2]:.4f}")

h_Sun = 3 * (R_e**2 / R_sun) * ((k_equator/R_e)**2 - (k_polar/R_e)**2) * np.sin(theta_Sun)
print(f"h_Sun ={h_Sun:.4f}")

# Satellite effects
k_sat = 15
k_sat_prime = 10
R_sat = R_e + 500e3
theta_sat = np.radians(30)
beta_sat = 2 * np.pi / 60

om_sat = 1.5 * 9.807 * (R_e / R_sat)**2 * (1 - (k_sat_prime**2 / k_sat**2)) * np.cos(theta_sat) / (R_sat * beta_sat)
print(f"om_sat = {om_sat:.4e}")

F_ratio = (M_m / M_s) * (R_sun / R_moon)**2
M_ratio = (M_m / M_s) * (R_sun / R_moon)**3 * np.sin(theta_Moon) / np.sin(theta_Sun)
print(f"F_ratio = {F_ratio:.4f}")
print(f"M_ratio = {M_ratio:.4f}")
