import numpy as np
from scipy.integrate import solve_ivp
import matplotlib.pyplot as plt

# Parameters
m_truck = 8000  # kg
m_conc = 42000  # kg
m_0 = m_truck + m_conc  # Initial mass
m_dot = m_conc / (3 * 180)  # Rate of mass loss
u = 25  # m/s
theta = 55 * np.pi / 180  # radians
equiv_T = m_dot * u * np.sin(theta)  # Equivalent thrust

# Define the ODE system
def Z_dot(t, Z):
    m_t = m_0 - m_dot * t
    return [Z[1], equiv_T / m_t]

# Time span and initial conditions
t_span = (0, 179.99999)
Z0 = [0, 0]  # [s, ds]

# Solve the system
sol = solve_ivp(Z_dot, t_span, Z0, t_eval=np.linspace(*t_span, 1000))

# Extract solutions
t = sol.t
s = sol.y[0]
ds = sol.y[1]

# Output results
print("Max displacement (s):", np.max(s))
print("Max velocity (ds):", np.max(ds))

# Optional: plot the results
plt.figure()
plt.plot(t, s, label='Displacement (s)')
plt.plot(t, ds, label='Velocity (ds)')
plt.xlabel('Time (s)')
plt.ylabel('Values')
plt.title('Concrete Truck Motion')
plt.legend()
plt.grid(True)
plt.show()
