''' 
Calculations to accompany Example 3.4 in Chapter 3 - multiple rotations
'''

import numpy as np

def simple_rotations(theta, axis_number):
    """Generates a rotation matrix for a given angle and axis."""
    if axis_number == 1:
        R = np.array([[1, 0, 0],
                      [0, np.cos(theta), np.sin(theta)],
                      [0, -np.sin(theta), np.cos(theta)]])
    elif axis_number == 2:
        R = np.array([[np.cos(theta), 0, -np.sin(theta)],
                      [0, 1, 0],
                      [np.sin(theta), 0, np.cos(theta)]])
    elif axis_number == 3:
        R = np.array([[np.cos(theta), np.sin(theta), 0],
                      [-np.sin(theta), np.cos(theta), 0],
                      [0, 0, 1]])
    else:
        raise ValueError("axis_number must be 1, 2, or 3")
    return R

# Rotation angles in radians
theta_vals = np.radians([65, -145, 200])

# Apply rotations in the order specified
R_1 = simple_rotations(theta_vals[0], 2)  # about y-axis
R_2 = simple_rotations(theta_vals[1], 3)  # about z-axis
R_3 = simple_rotations(theta_vals[2], 1)  # about x-axis

# Combined rotation matrix
R = R_2 @ R_1 @ R_3

print("Rotation Matrix R:")
print(R)

# Vectors
R_a = np.array([2, -4, 3])
r_b = np.array([2, -4, 3])

# Transformed vectors
r_a = R @ R_a
R_b = R.T @ r_b

print("\nTransformed vector r_a (R * R_a):")
print(r_a)

print("\nTransformed vector R_b (R' * r_b):")
print(R_b)
