"""
% Calculations to accompany Chapter 3, Example 3
"""
import numpy as np

# Define rotation matrices
R_1 = np.array([
    [0, -1, 0],
    [1, 0, 0],
    [0, 0, 1]
])

R_2 = np.array([
    [1, 0, 0],
    [0, np.cos(np.pi/6), np.sin(np.pi/6)],
    [0, -np.sin(np.pi/6), np.cos(np.pi/6)]
])

phi = -np.arccos(np.cos(np.deg2rad(110)) / np.cos(np.deg2rad(30)))
phi_deg = np.degrees(phi)

print(f"phi = {phi:9.4f}")

print(f"phi_deg = {phi_deg:9.4f}\n")

R_3_a = np.array([
    [np.cos(phi), 0, -np.sin(phi)],
    [0, 1, 0],
    [np.sin(phi), 0, np.cos(phi)]
])

R_3_b = np.array([
    [np.cos(-phi), 0, -np.sin(-phi)],
    [0, 1, 0],
    [np.sin(-phi), 0, np.cos(-phi)]
])

print("R_3_a =")
for row in R_3_a:
    print(f"{row[0]:9.4f}    {row[1]:7.4f}   {row[2]:7.4f}")
print()

print("R_3_b =")
for row in R_3_b:
    print(f"{row[0]:9.4f}    {row[1]:7.4f}   {row[2]:7.4f}")
print()

R_2_1 = R_2 @ R_1
print("R_2_1 =")
for row in R_2_1:
    print(f"{row[0]:9.4f}    {row[1]:7.4f}   {row[2]:7.4f}")
print()

R_a = R_3_a @ R_2 @ R_1
R_b = R_3_b @ R_2 @ R_1

print("R_a =")
for row in R_a:
    print(f"{row[0]:9.4f}    {row[1]:7.4f}   {row[2]:7.4f}")
print()

print("R_b =")
for row in R_b:
    print(f"{row[0]:9.4f}    {row[1]:7.4f}   {row[2]:7.4f}")
print()

# Compute angles from row 3, columns 1 and 2
ans1 = np.degrees(np.arccos(R_a[2, 0:2]))
ans2 = np.degrees(np.arccos(R_b[2, 0:2]))

print(f"ans = {ans1[0]:9.4f}  {ans1[1]:9.4f}")

print(f"ans = {ans2[0]:9.4f}  {ans2[1]:9.4f}")
