import numpy as np

# Calculations to accompany Chapter 3, Example 1
L_zz = np.cos(np.deg2rad(110))
j_prime = np.array([np.cos(np.pi / 6), 0.0, np.sin(np.pi / 6)], dtype=float)
print("j_prime =", j_prime)

proj = np.cos(np.deg2rad(20))
dot_x = proj * j_prime[0]
dot_z = L_zz * j_prime[2]
theta = np.arcsin(-dot_z / dot_x)

k_prime = np.array([proj * np.sin(theta), proj * np.cos(theta), L_zz], dtype=float)
print("k_prime =", k_prime)

i_prime = np.cross(j_prime, k_prime)
print("i_prime =", i_prime)

R = np.vstack([i_prime, j_prime, k_prime])
print("R = ",R)

print("Part (b)")
r_A_xyz = np.array([-250.0, 400.0, -500.0])
r_A_xpypzp = R @ r_A_xyz
print("r_A_xpypzp =", r_A_xpypzp)

print("Part (c)")
r_B_xpypzp = np.array([400.0, -600.0, 200.0])
r_B_xyz = R.T @ r_B_xpypzp
print("r_B_xyz =", r_B_xyz)

print("Part (d)")
r_BwrtA_xyz = r_B_xyz - r_A_xyz
r_BwrtA_xpypzp = r_B_xpypzp - r_A_xpypzp
print("r_BwrtA_xyz =", r_BwrtA_xyz)
print("r_BwrtA_xpypzp =", r_BwrtA_xpypzp)

print("Check that the results are identical after rotating to the same coordinate system")
check = r_BwrtA_xpypzp - (R @ r_BwrtA_xyz)
print("check =", check)

Px = r_BwrtA_xyz.T @ r_BwrtA_xyz
P_x_prime = r_BwrtA_xpypzp.T @ r_BwrtA_xpypzp

print("Check that lengths are all identical")
L = np.array([np.sqrt(Px), np.sqrt(P_x_prime), np.linalg.norm(r_BwrtA_xyz)], dtype=float)
print("L =", L)
