'''
Script to create plot of particle motion in hurricane
'''
import numpy as np
import matplotlib.pyplot as plt

FF = 1
om_rel = 1
r_0 = 1
t_max = 1.2
t = np.linspace(0, t_max, 101)
N_heads = 24

psi = np.linspace(0, 2 * np.pi, N_heads + 1)

x = lambda t, psi: np.cos(psi) * (r_0 - 0.5 * FF * t**2) \
    - (1/3) * om_rel * FF * np.sin(psi) * t**3

y = lambda t, psi: np.sin(psi) * (r_0 - 0.5 * FF * t**2) \
    + (1/3) * om_rel * FF * np.cos(psi) * t**3

# figure(1)
fig, ax = plt.subplots()

for n in range(len(psi)):
    xx = x(t, psi[n])
    yy = y(t, psi[n])
    # x is north, graphed X is right;
    # y is west, graphed Y is up
    # x axis is north (up) and y axis is west (left)
    ax.plot(-yy, xx, '-k', linewidth=1)

ax.plot([-r_0/4, 0, 0], [0, 0, r_0/4], 'k', linewidth=1)

ax.set_aspect('equal')
# xlim([-1.05 * r_0, 1.05 * r_0])
# ylim([-1.05 * r_0, 1.05 * r_0])
ax.set_xlim([-1.05 * r_0, 1.05 * r_0])
ax.set_ylim([-1.05 * r_0, 1.05 * r_0])
plt.show()
