# -*- coding: utf-8 -*-
"""
Engineering Dynamics 2nd Edition 2025
"""
import numpy as np

def skew(A):
    """ Returns the skew-symmetric matrix of a 3D vector A. """
    return np.array([[0, -A[2, 0], A[1, 0]],
                     [A[2, 0], 0, -A[0, 0]],
                     [-A[1, 0], A[0, 0], 0]])

# Define column vectors
A = np.array([[1], [2], [3]])
B = np.array([[3], [-1], [-5]])
print("A, B, C")
print(np.hstack([A, B]))
print()

# Compute skew-symmetric matrix of A
skew_A = skew(A)

# Cross product
C = np.cross(A.flatten(), B.flatten()).reshape(3, 1)

# Unit vectors
e_A = A / np.linalg.norm(A)
e_B = B / np.linalg.norm(B)
e_C = C / np.linalg.norm(C)

print("e_A, e_B, e_C")
print(np.hstack([e_A, e_B, e_C]))
print()

# Triple scalar product
Triple_dot = e_C.T @ skew_A @ B # Transpose of e_C * skew_A * B
abs_C = np.linalg.norm(C)
print(f"A x B . e_C = {Triple_dot.item()},  |C| = {abs_C}")
print()

# Triple product identities
Triple_1 = skew(skew_A @ B) @ C
Triple_2 = skew_A @ skew(B) @ C
Triple_ident = (A.T @ C) * B - (A.T @ B) * C

print()
print("(A x B) x C, A x (B x C), (A' * C) * B - (A' * B) * C")
print(np.hstack([Triple_1, Triple_2, Triple_ident]))


