# -*- coding: utf-8 -*-
"""
Engineering Dynamics 2nd Edition 2025
"""

import numpy as np

def skew(A):
    """ Returns the skew-symmetric matrix of a 3D vector A. """
    return np.array([[0, -A[2, 0], A[1, 0]],
                     [A[2, 0], 0, -A[0, 0]],
                     [-A[1, 0], A[0, 0], 0]])

# Define angles in radians
th = 25 * np.pi / 180
gam = 40 * np.pi / 180

# Define position vectors
r_B_A = 2 * np.array([[np.cos(th)], [np.sin(th)], [0]])
r_C_B = 1.5 * np.cos(gam) * np.array([[np.cos(th)], [np.sin(th)], [0]]) + \
        1.5 * np.sin(gam) * np.array([[0], [0], [1]])
r_C_A = r_B_A + r_C_B
r_D_C = np.array([[3.5], [0], [0]]) - r_C_A

# Unit vector along D to C
e_D_C = r_D_C / np.linalg.norm(r_D_C)

# Force vector
F = 5000 * e_D_C

# Force projection along BC
F_BC = (F.T @ r_C_B) / np.linalg.norm(r_C_B)

# Moment at A
M_A = skew(r_C_A) @ F

# Moment at A along z-axis
M_Az = M_A.T @ np.array([[0], [0], [1]])

# Moment projection along AB
M_AB = (M_A.T @ r_B_A) / np.linalg.norm(r_B_A)

# Display results
print("Force Vector F:\n", F)
print("\nForce along BC:", F_BC)
print("\nMoment at A:\n", M_A)
print("\nMoment at A along z-axis:", M_Az.item())
print("\nMoment projection along AB:", M_AB.item())