function [Zdot]=G_aug_pendulum(t,Z)
% Equations of motion for pendulum with constrained GCs, using Augmented
% algorithm.
% Z = [q, qdot], Zdot = [qdot, qddot]

q=Z(1:2); x=q(1); y=q(2);
qdot=Z(3:4); xd=qdot(1); yd=qdot(2);

m=1; % kg
g=9.81; % gravity
R=1; % m
Mt=[m,0; 0,m]; Ft=[0; m*g];
at=[x, y]; apt=[xd, yd];
bt=0; bpt=0;

Mm=[Mt, -at.';
    -at, 0];
Fm = [Ft; apt*qdot+bpt];
Y = Mm\Fm;
% top rows = qddot, bottom rows = lambda = lagrange multiplier
qddot=Y(1:2);
% Return state vector.
Zdot=[qdot; qddot];
