% Integrate EOM for Pendulum with Constrained GCs and compare

% Augmented Algorithm
% Z = [q, qdot], function Zdot=G_aug_pendulum(Z,t)
% ICs: x=1, y=1 (pendulum at 45 degrees) with zero velocity
% options=odeset('RelTol',1e-3,'AbsTol',1e-6); % Defaults 1e-3, 1e-6
options=odeset('RelTol',1e-6,'AbsTol',1e-9); % Defaults 1e-3, 1e-6
[ts,ys]=ode45('G_aug_pendulum',[0,10],[1; 0; 0; 0],options);
xt=ys(:,1); yt=ys(:,2);
Rt=sqrt(xt.^2+yt.^2);
thetat=atan2(yt,xt);

figure(1)
subplot(2,1,1);
plot(ts,thetat*180/pi); grid on;
xlabel('Time (s)'); ylabel('Angle (deg)');
subplot(2,1,2);
plot(ts,Rt); grid on;
xlabel('Time (s)'); ylabel('Pendulum Length');