% Find_brachistocrone
X_0 = 5.0;
Y_0 = 4.0;
F_psi =  @(psi) 2 * psi - sin(2 * psi) - (X_0/Y_0) * (1 - cos(2 * psi));
Psi = [0 : 0.01: 1] * 2 * pi;
figure(10)
plot(Psi, F_psi(Psi))
xlabel('\bf\Psi'); ylabel('\bfF(\Psi)')
grid on
Psi_guess = 0.2;
Psi_0 = fzero(F_psi, Psi_guess)
Const = (1 - cos(2 * Psi_0))/Y_0;
Psi_vals = [0 : 0.01 : 1] * Psi_0;
X_vals = (2 * Psi_vals - sin(2 * Psi_vals))/Const;
Y_vals = (1 - cos(2 * Psi_vals))/Const;
figure(20)
% subplot(2,1, 2)
plot(X_vals, Y_vals)
xlabel('\bfX'); ylabel('\bfY')
ax = gca;
zax.XDir = 'normal';
ax.YDir = 'reverse';
axis equal
