function [a, a_dot] = a_a_dot_rolling_disk(Z, Radius)

% function [a, a_dot] = a_deriv(z, Radius)
% Compute Jacobian constraint matrix [a] and (d/dt)[a] for a wobbling disk

psi = Z(3);
theta = Z(4);
psi_dot = Z(8);
theta_dot = Z(9);

a(1,1) = 1;
a(1,2) = 0;
a(1,3) = - Radius * sin(psi) * cos(theta);
a(1,4) = - Radius * cos(psi) * sin(theta);
a(1,5) = - Radius * sin(psi);
a(2,1) = 0;
a(2,2) = 1;
a(2,3) = Radius * cos(psi) * cos(theta);
a(2,4) = - Radius * sin(psi) * sin(theta);
a(2,5) = Radius * cos(psi);

a_dot(1,1) = 0;
a_dot(1,2) = 0;
a_dot(1,3) = Radius * (- psi_dot * cos(psi) * cos(theta) ...
            + theta_dot * sin(psi) * sin(theta));
a_dot(1,4) = Radius * (psi_dot * sin(psi) * sin(theta) ...
            - theta_dot * cos(psi) * cos(theta));
a_dot(1,5) = - Radius * psi_dot * cos(psi);

a_dot(2,1) = 0;
a_dot(2,2) = 0;
a_dot(2,3) = Radius * (-psi_dot * sin(psi) * cos(theta) ...
            - theta_dot * cos(psi) * sin(theta));
a_dot(2,4) = Radius * (-psi_dot * cos(psi) * sin(theta) ...
            - theta_dot * sin(psi) * cos(theta));
a_dot(2,5) = -Radius * psi_dot * sin(psi);

% Version from third ed
% q = Z(1 : 5);
% q_dot = Z(6 : 10);
% a(1,1) = 1;
% a(1,2) = 0;
% a(1,3) = - Radius * cos(q(3)) * cos(q(4));
% a(1,4) = Radius * sin(q(3)) * sin(q(4));
% a(1,5) = - Radius * cos(q(3));
% a(2,1) = 0;
% a(2,2) = 1;
% a(2,3) = - Radius * sin(q(3)) * cos(q(4));
% a(2,4) = - Radius * cos(q(3)) * sin(q(4));
% a(2,5) = - Radius * sin(q(3));
% 
% a_dot(1,1) = 0;
% a_dot(1,2) = 0;
% a_dot(1,3) = Radius * (q_dot(3) * sin(q(3)) * cos(q(4)) ...
%             + q_dot(4) * cos(q(3)) * sin(q(4)));
% a_dot(1,4) = Radius * (q_dot(3) * cos(q(3)) * sin(q(4)) ...
%             + q_dot(4) * sin(q(3)) * cos(q(4)));
% a_dot(1,5) = Radius * q_dot(3) * sin(q(3));
% a_dot(2,1) = 0;
% a_dot(2,2) = 0;
% a_dot(2,3) = Radius * (- q_dot(3) * cos(q(3)) * cos(q(4)) ...
%             + q_dot(4) * sin(q(3)) * sin(q(4)));
% a_dot(2,4) = Radius * (q_dot(3) * sin(q(3)) * sin(q(4)) ...
%             - q_dot(4) * cos(q(3)) * cos(q(4)));
% a_dot(2,5) = - Radius * q_dot(3) * cos(q(3));
end
