function Rolling_disk_plot(t_val_in, z_val_in)
%
% Plot responses for a wobbling disk
% Data is output from Rolling_disk_aug.m
%
% Curve markings: 
%     t-X = 	red solid
%     t-Y = 	green dotted
%     t-psi = 	blue dashdot
%     t-theta =	yellow dashed

% file_nam = input('Enter the file name to store the data -- ', 's');
% if length(file_nam) > 0
% 	fid = fopen(file_nam, 'w');
% 	cr_lf  = setstr([13 10]);  %  Define carriage return & line feed
% 	bytes = 0;
%     for i = 1 : length(t_val);
% 	y = [t_val(i), x_val(i,1:11)];
% 	for j = 1 : 12
% 		count = fprintf(fid, '%15.5e', y(j));
% 		bytes = bytes + count;
% 	end
% 	fprintf (fid, cr_lf); 
%     end
%     fclose(fid);
% end
% 
% disp (['bytes written = ' int2str(bytes)]);

max_data = length(t_val_in);
disp(['Full length of data = ', num2str(max_data)]);
m_max = 2000;
disp(['Number of instants to plot = 2000']);
t_val = t_val_in(1 : m_max);
z_val = z_val_in(1 : m_max, :);
% abs_F_XY = abs_F_XY_in(1 : m_max);
% F_Z = F_Z_in(1 : m_max);

mark_sep = floor(m_max/16);
mark_index = [mark_sep : mark_sep : m_max];
figure(1)
subplot(3, 1, 1)
plot(t_val, z_val(:,1), 'r-', t_val, z_val(:,2),'-bo', 'MarkerSize', 2, ...
    'MarkerIndices', mark_index, 'LineWidth', 0.75)
legend('X (meter)', 'Y (meter)');

subplot(3, 1, 2)
yyaxis left
plot(t_val, z_val(:,4) * 180/pi,'r-', 'LineWidth', 0.75)
yyaxis right
plot(t_val, z_val(:, 3) * 180/pi, '-bo', 'MarkerSize', 2, ...
    'MarkerIndices', mark_index, 'LineWidth', 0.75)
legend('\theta (deg)', '\psi (deg)');
ylim([-1000  max(z_val(:, 3) * 180/pi)])

subplot(3, 1, 3)
plot(t_val, z_val(:,9),'r-', t_val,  z_val(:,10),'-bo', 'MarkerSize', 2, ...
    'MarkerIndices', mark_index, 'LineWidth', 0.75)
legend('d\psi/dt (rad/s)', 'd\phi/dt (rad/s)');
ylim([min(z_val(:,10) - 5)  max(z_val(:,8) + 5)])
xlabel('Time (seconds)');

figure(2)
X = z_val(:,1);
Y = z_val(:,2);
X_min = min(X);
X_max = max(X);
Y_min = min(Y);
Y_max = max(Y);
edge = 0.1 * max(abs([X_min, X_max, Y_min, Y_max]));
% X_min = 1.1 * X_min * (X_min <= 0) + 0.9 * X_min * (X_min > 0);
% Y_min = 1.1 * Y_min * (Y_min <= 0) + 0.9 * Y_min * (Y_min > 0);
% X_max = 1.1 * X_max * (X_max > 0) + 0.9 * X_max * (X_max <= 0);
% Y_max = 1.05 * Y_max * (Y_max > 0) + 0.9 * Y_max * (Y_max <= 0);
X_min = X_min - edge;
Y_min = Y_min - edge;
X_max = X_max + edge;
Y_max = Y_max + edge;
daspect('manual');
daspect([1 1 1]);
% plot(z_val(:,1), z_val(:,2),'r-', X_min, Y_min, 'k:', X_max, Y_max, 'k:')
plot(z_val(:,1), z_val(:,2),'k-', [0], Y_min, 'w:', [0], Y_max, 'w:')
line(z_val(t_val<1,1), z_val(t_val<1,2),'Color','b');
axis equal
xlabel('X (meter)');
ylabel('Y (meter)'); 

figure(3)
plot3(z_val(:, 1), z_val(:, 2), t_val)

% figure(4)
% subplot(3, 1, 1)
% plot(t_val, abs_F_XY, 'r-', t_val, F_Z, '-bo', 'MarkerSize', 2, ...
%     'MarkerIndices', mark_index, 'LineWidth', 0.75)
% legend('F_h (newtons)', 'F_z (newtons)')
% subplot(3, 1, 2)
% plot(t_val, abs_F_XY./F_Z, '-r')
% xlabel('time (seconds)')
