function M_mat = M_mat_disk(q, Radius, kappa)
% Compute [M] for a wobbling disk

% Radius is radius of the disk
% kappa is the radius of gyration

theta = q(4);

M_mat = [zeros(5)];
M_mat(1, 1) = 1;
M_mat(2, 2) = 1;
M_mat(3, 3) = 0.5 * kappa^2 * (1 + cos(theta)^2);
M_mat(3, 5) = kappa^2 * cos(theta);
M_mat(4, 4) = 0.5 * kappa^2 + (Radius * cos(theta))^2;
M_mat(5, 3) = M_mat(3,5);
M_mat(5, 5) = kappa^2;
end
