function [Z_dot] = G_vec_squeeze(Z, t, p)
% Function to evaluate dZ/dt corresponding to input values of Z and t,
%   and a set of system parameters.
% Decompose the input value of Z:
N = 3;
q = Z(1 : N);
theta = q(1);
d_theta = Z(4);
s = p. R * cot(theta/2);
d_s = -0.5 * p.R * d_theta/sin(theta/2)^2;
s = p.R * cot(theta/2);
q_dot = Z(N + 1 : 2 * N);
Q = [-p.Force * p.L; 0;  0];
M_inertia = [[p.I_C,  0,  0]; [0,  (p.I_A + p.m_A * p.R^2), -p.m_A * p.R]; ...
    [ 0,  -p.m_A * p.R,  (p.m_B + p.m_A)]];
    
FF = Q + [-(p.m_C * 9.807 * p.L * cos(theta));  0;  0];

a = [[cos(theta) * (1 + cos(theta)), sin(theta)^2,  0];...
    [p.R * (1 + cos(theta)), -p.R * sin(theta)^2,  sin(theta)^2]];
da_dt(1, :) = d_theta * [-sin(theta) * (1 + 2 * cos(theta)),...
    2 * sin(theta) * cos(theta), 0];
da_dt(2, :) = d_theta * [-p.R * sin(theta), -2 * p.R * sin(theta) * cos(theta), ...
    2 * sin(theta) * cos(theta)];
    
RHS = [FF; da_dt * q_dot];
LHS = [[M_inertia,  -a'];[-a,  zeros(2, 2)]];
X = LHS\RHS;

q_2dot = X(1 : 3, 1);
Z_dot = [q_dot;  q_2dot];
end

