function [Z_dot] = GG_vec_linkage_friction(Z, t, N_D, m_AB, m_BC, L,... 
    beta_L, k_stiff, Gam, mu_k)
% Function to evaluate dZ/dt corresponding to input values of Z and t,
%   and a set of system parameters.

N = 2;
Torque = Gam;

% Decompose the input value of Z:
q = Z(1 : N);
q_dot = Z(N + 1 : 2 * N);
u_D = - L * q_dot(1) * sin(q(1) + q(2));

M_mat(1, 1) = (m_AB/3 + m_BC) * L^2;
M_mat(1, 2) = - 2 * m_BC * cos(q(1) + q(2)) * L^2;
M_mat(2, 1) = M_mat(1, 2);
M_mat(2, 2) = (16/3) * m_BC * L^2;
%  Alternative descriptions of the moment of the spring force about pin A
alpha = sqrt(5 - 4 * cos(q(1)));
% Spring ELONGATION is L * (4 - beta_L - alpha), elongation pulls end C, 
%   so corresponding moment is counter clockwise. 
%   Because alpha >= 1, if 3 <= beta_L < = 4 the moment will be negative, i.e. cw.
% Gamma_spr_1 = k_stiff * L^2 .* (4 - beta_L - alpha) .* sin(q(1) + q(2));
Gamma_spr_2 = -2 * k_stiff *L^2 .* sin(q(1)) .* (1 - (4 - beta_L)./alpha);

FF(1, 1) = Torque - 2 * m_BC * L^2 * sin(q(1) + q(2)) * q_dot(2)^2 ...
    + Gamma_spr_2;
FF(2, 1) = - 2 * m_BC * L^2 * sin(q(1) + q(2)) * q_dot(1)^2;

alpha = sqrt(5 - 4 * cos(q(1)));
sigma_mat = L * [cos(q(1) + q(2)),  -alpha];
gamma_mat = [-mu_k * (2 * L) * abs(sin(q(2))) * sign(q_dot(1)),  0];

% Config constraint: alpha * sin(phi) = sin(theta)
% alpha_prime = 2 * sin(q(1))/alpha;
% alpha_2prime = 2 * cos(q(1))/alpha - 2 * sin(q(1)) * alpha_prime/alpha^2;
% a(1, 1) = (alpha_prime * sin(q(2)) - cos(q(1)))/(alpha * cos(q(2)));
% a(1, 2) = 1;
% da_dt(1, 1) = (alpha_2prime * q_dot(1) * sin(q(2)) + alpha_prime * q_dot(2) * cos(q(2)) ...
%     + q_dot(1) * sin(q(1)))/(alpha * cos(q(2))) - (alpha_prime * sin(q(2)) - cos(q(1))) ...
%     * (alpha_prime * q_dot(1) * cos(q(2)) - alpha * q_dot(2) * sin(q(2)))/(alpha * cos(q(2)))^2;
% da_dt(1, 2) = 0;

% Config constraint: sin(theta + phi) - 2 * sin(phi) = 0
a(1, 1) = cos(q(1) + q(2));
a(1, 2) = cos(q(1) + q(2)) - 2 * cos(q(2));
da_dt(1, 1) = - (q_dot(1) + q_dot(2)) * sin(q(1) + q(2));
da_dt(1, 2) = - (q_dot(1) + q_dot(2)) * sin(q(1) + q(2)) + 2 * q_dot(2) * sin(q(2));

% Velocity constraint: v_D dot n_1 = 0
% alpha_prime = 2 * sin(q(1))/alpha;
% a(1, 1) = cos(q(1) + q(2));
% a(1, 2 ) = -alpha;
% da_dt(1, 1) = - (q_dot(1) + q_dot(2)) * sin(q(1) + q(2));
% da_dt(1, 2) = - alpha_prime;

RHS = [FF; da_dt * q_dot];
LHS = [[M_mat,  -(sigma_mat' + gamma_mat' * sign(N_D))]; [-a,  0]];
% if rcond(LHS) < 1e-10
%     pause
% end
X = LHS\RHS;
q_2dot = X(1 : 2, 1);
Z_dot = [q_dot;  q_2dot];
end
