function [Z_dot] = G_vec_disk_aug(t, Z, Radius, kappa)
% Solution for example of a rolling disk.
% Compute G(Z) = dZ/dt for a rolling disk, where Z is the state-space vector.
% The input to the ODE solver is G at a specified state;

q = Z(1 : 5);
q_dot= Z(6 : 10); 
[a_mat, a_dot_mat] = a_a_dot_disk(Z, Radius);
M_mat = M_mat_disk(q, Radius, kappa);
F_vec = F_vec_disk(Z, Radius, kappa);

% Augmented method
LHS = [[M_mat  -a_mat']; [-a_mat  zeros(2)]]; 
RHS = [F_vec;  a_dot_mat * q_dot]; 
sol = LHS\RHS; 
q_2dot = sol(1:5); 
Z_dot = [q_dot; q_2dot];
end
