function FF = F_vec_disk(Z, Radius, kappa)
% Compute {F} in Lagrange's equations for a wobbling disk
% {z} is the current state-space vector: 
%     number of generalized coordinates is 5, so size of {Z} is 10
% Sequence of generalized coordinates is:
%     Z(1) = X, Z(2) = Y, Z(3) = psi, Z(4) = theta, Z(5) = phi
% Sequence of generalized velocities is:
%     Z(6) = X_dot, Z(7) = Y_dot, Z(8) = psi_dot, Z(9) = theta_dot, Z(10) = phi_dot
% radius is radius of the disk
% kappa is the radius of gyration

q = Z(1 : 5);
q_dot = Z(6 : 10);
FF(1 : 2, 1) = 0;
FF(3, 1) = kappa^2 *(0.5 * q_dot(3) * q_dot(4) * sin(2 * q(4)) ...
    +  q_dot(4) * q_dot(5) * sin(q(4)));
FF(4, 1) = -0.5 * (0.5 * kappa^2 * q_dot(3)^2 - Radius^2 * q_dot(4)^2) * sin(2*q(4)) ...
        - kappa^2 * q_dot(3) * q_dot(5) * sin(q(4)) - 9.807 * Radius * cos(q(4));
FF(5, 1) = kappa^2 * q_dot(3) * q_dot(4) * sin(q(4));
end
