% Response_Unconstrained.m
% This script solves differential equations of motion that are obtained 
%    by converting Lagrange's equations to matrix form.
% The generalized coordinates must be unconstrained.
% This program requires creation of function G_vec
%    that evaluates d{Z}/dt.
% In addition, system parameters and initial conditions for the 
%      generalized coordinates must be entered below, as well as the
%      timespan over which the solution is to be computed.
clear
% Define system parameters here. param is a structure data type
    param.L = ...; param.I_zz = ...; param.width=...;
    param.m = ...;
% Set initial conditions:
    t_0 = ....;
    t_max = ...;
    q_0 = ....; % Both q_0 and q_dot_0 should be column vectors.
    q_dot_0 = ...;
    N = length(q_0);
    % Collect initial conditions into a single vector of state-space 
    % initial conditions.
    Z_0 = [q_0;  q_dot_0];
% Set error tolerances. This step is optional. Omission of Tols from the 
% input is equivalent to setting the defaults:
    Tols = odeset('AbsTol',1e-6,'RelTol',1e-3);
% Call ode45 to compute the response Z=[q; q_dot] from t_0 to t_max.
%    The function G_vec, which evaluates d{Z}/dt for given values of 
%    Z, t, and param, must be situated in the search path.
% An anonymous function @(t,Z) is created and passed to ode45, in order
% to provide G_vec with the system parameters in the param structure.
[t_ode, Z_ode] = ode45(@(t, Z) G_vec(t, Z, param),...
    [t_0, t_max], Z_0, Tols);
% The output consists of column vector t_ode and Z_ode, which is a
%   rectangular array whose number of rows equals the length of t_ode.
% Extract rectangular arrays of generalized coordinates
%   and velocities.
q = Z_ode(:, 1:N); q_dot = Z_ode(:, N+1:2*N);
% Add post-processing here, such as plotting the results.