% Gravitational_moments
G = 6.6743e-11;
% Masses
M_e = 5.972e+24;
M_m = 7.34767309e22;
M_s = 1.9891e30;

% Inertia of Earth
r_polar = 6356752 %meters
r_equator = 6376137
R_e = 6371000; %(mean value)
k_polar = sqrt((2/5) * r_equator^2)
k_equator = sqrt((1/5) * (r_polar^2 + r_equator^2))
I = M_e * k_polar^2;
I_prime = M_e * k_equator^2;

% Orbital distances
% Sun:
a = 147.095e9;
b = 152.100e9;
R_sun = sqrt(a * b)
%  Moon:
R_moon = 3.84748e8;

Gam_Sun = (3/2) * G * (M_s/(R_sun^3)) * (I - I_prime);
Gam_Moon = (3/2) * G * (M_m/(R_moon^3)) * (I - I_prime);

one_day = 23 * 3600 + 56 * 60 + 4.091 % Seconds in a day
one_year = 31557600 % Seconds in a year
Omega = 2 * pi/one_year

theta_Sun = 23.44 * pi/180;
theta_Moon = (5.145 + 23.44) * pi/180;
phi_dot = 2 * pi/one_day
beta = phi_dot;
w_psi_Sun = cos(theta_Sun) * Gam_Sun/(I * beta)
w_psi_Moon = cos(theta_Moon) * Gam_Moon/(I * beta)

T_Sun = pi/w_psi_Sun % Time delay for a vernal equinoxe
T_Moon = pi/w_psi_Moon 
T_comb = pi/(w_psi_Sun + w_psi_Moon)
[T_Sun  T_Moon  T_comb]/one_year

h_Sun =  3 * (R_e^2/R_sun) * ((k_equator/R_e)^2 - (k_polar/R_e)^2) * sin(theta_Sun)

% Earth effect on a satellite
k_sat = 15;
k_sat_prime = 10;
% R_sat = 42164e3; % Synchronous orbit from web
% R_sync = (G * M_e/w^2)^(1/3)
R_sat = R_e + 500e3;
theta_sat = 30 * pi/180;
beta_sat = 2 * pi/60;
% om_sat = 1.5 * (G * M_e/R_sat^3) * (1 - k_sat_prime^2/k_sat^2) * cos(theta_sat)/beta_sat
om_sat = 1.5 * 9.807 * (R_e/R_sat)^2 * ...
    (1 - k_sat_prime^2/k_sat^2) * cos(theta_sat)/(R_sat * beta_sat)


F_ratio = (M_m/M_s) * (R_sun/R_moon)^2
M_ratio = (M_m/M_s) * (R_sun/R_moon)^3*sin(theta_Moon)/sin(theta_Sun)
