function [Z_dot] = G_vec_rack(Z, t, p)
% Function to evaluate d{Z}/dt corresponding to input values of Z and t,
% and a set of system parameters.  The parameters are in the variable "p"
% and can be accessed by name as p.F_mag, p.m_A, etc...
N = length(Z)/2;
% Decompose the input value of Z:
q = Z(1:N);
q_dot = Z(N+1:2*N);
Force = p.F_mag*sin(p.freq*t);
% Define the generalized forces
Q(1) = Force;
Q(2) = (p.radius + p.e_offset*cos(q(2)))*Force;
% Define the nonlinear function of the states
FF(1, 1) = Q(1) + (p.m_A + p.m_r)*p.e_offset*sin(q(2))*q_dot(2)^2 ...
    - p.k_stiff*(q(1) - 2*p.radius);
FF(2, 1) = Q(2) + ((p.m_A + p.m_r) * p.e_offset^2 * 0.5 * sin(2 * q(2)) ...
    + p.m_r * p.radius * p.e_offset * sin(q(2))) * q_dot(2)^2;
% Define the Mass matrix
M_coeffs(1,:) = [p.m_A + p.m_r + p.m_s, (p.m_r*p.radius + ...
    (p.m_A + p.m_r)*p.e_offset*cos(q(2)))];
M_coeffs(2,:) = [(p.m_r*p.radius + (p.m_A + p.m_r)*p.e_offset*cos(q(2))), ...
    (p.m_A * p.kappa^2 + p.m_A*p.e_offset^2*cos(q(2))^2 + ...
    p.m_r * (p.radius + p.e_offset*cos(q(2)))^2)];
q_ddot = M_coeffs\FF;
Z_dot = [q_dot; q_ddot];
end