function Z_dot = G_vec(Z, t, param)
% Function to evaluate dZ/dt corresponding to input values of Z and t.
% Another input is param, which is a data structure that consists of a
%   set of system parameters.
% Separate the input vector Z into q and q_dot
    N = length(Z)/2;
    Z_U = Z(1:N);
    Z_L = Z(N+1:2*N);
% Call a function M_mat to compute [M], which is stored in file M_mat.m
    M_coef = M_mat(Z_U, t, param);
% Call a function F_vec to compute {F}, which is stored in file F_vec.m
    FF = F_vec(Z_U, Z_L, t, param);
% The "\" or "left divide" operator uses the optimal algorithm to solve
%   the simultaneous equations
    Y = M_coef\FF;
    Z_dot = [Z_L;  Y];
end