% Satellite_meteor_impact
% Code for solution to Example 6.21
m_s = 5000;
I = diag([32000,  40000,  3600]);
m_m = 2;
eps_co = 0.3;
v_C_0 = [0,  0,  8000]';
om_0 = [0,  0,  3]';
v_m_0 = [-9000,  12000,  0]';
w_0 = 12000;
r_A_C = [0,  -1.2,  -9]'; 
delta_t = 0.40;
r_AC_x = skew(r_A_C);
S = [0, 1, 0];
Z0 = zeros(3, 3);
U = eye(3);
A =[[Z0, Z0, m_m * U, S']; [m_s * U, Z0, m_m * U, zeros(3, 1)]; ...
    [Z0, I, Z0, -r_AC_x * S']; S * [U, -r_AC_x, -U,  zeros(3, 1)]];
B = [m_m * v_m_0; m_s * v_C_0 + m_m * v_m_0; I * om_0; ...
    -eps_co * S * (v_C_0 - r_AC_x * om_0 - v_m_0)];
Y = A\B;
% Extract variables
v_C_f = Y(1 : 3, 1);
om_f = Y(4 : 6, 1);
v_m_f = Y(7 : 9, 1);
F = Y(10, 1)/delta_t;
T_s_0 = 0.5 * m_s * norm(v_C_0)^2 + 0.5 * om_0' * I * om_0;
T_s_f = 0.5 * m_s * norm(v_C_f)^2 + 0.5 * om_f' * I * om_f;
T_m_0 = 0.5 * m_m * norm(v_m_0)^2;
T_m_f = 0.5 * m_m * norm(v_m_f)^2;

format short e
disp(' ');
disp_out('v_C_f = ', v_C_f');
disp_out('om_f = ', om_f');
disp_out('v_m_f = ', v_m_f');
disp_out('F = ', F);
disp_out('T_s_0', T_s_0);
disp_out('T_s_f - T_s_0', T_s_f - T_s_0);
disp_out('T_m_0', T_m_0);
disp_out('T_m_f - T_m_0', T_m_f - T_m_0);


function [dum] = disp_out(var_string, var_value)
%   Display a string and a number
format shortEng
disp([var_string, num2str(var_value)]);
end