%Linkage_with_friction
clear all
close all
beta_deg = 75;
beta = beta_deg * pi/180;
% mu = 0.0;
mu = 0.25;
% mu = 0.5;
% theta_deg = beta_deg - [0 : 3 : 75];
theta_deg = beta_deg - [0 : 0.5 : 75];
theta_deg(1) = beta_deg - 0.0001;
sig_vals = [[1, 1, - 1, -1]; 
            [1, -1, 1, -1]]; 
for n = 1 : 4
    sigma_A = sig_vals(1, n);
    sigma_B = sig_vals(2, n);
    for j = 1 : size(theta_deg, 2)
        theta = theta_deg(j) * pi/180;
        D = [[1, -mu, (sigma_B * sin(beta) - mu * cos(beta))];
            [0,  sigma_A, (sigma_B * cos(beta) + mu * sin(beta))];
            [sin(theta), (sigma_A * cos(theta) - mu * sin(theta)), ...
            (-sigma_B * cos(beta - theta) - mu * sin(beta - theta))]];
        K = (sin(beta)^2/cos(beta-theta)^3) * [0.5 * cos(beta);...
            -0.5 * sin(beta); -sin(beta - theta)/6];
        X = D\K;
        F(n, j) = X(1);
        N_A(n, j) = X(2);
        N_B(n, j) = X(3);
    end
end

figure(10)
subplot(2, 2, 1)
plot(theta_deg, N_A(1, :), 'k-', theta_deg, N_A(2, :), 'b--', theta_deg, N_A(3, :), 'g-.', ...
    theta_deg, N_A(4, :), 'r:')
xlim([0, 75]); xlabel('\theta (^o)'); ylabel('N_AL/mv^2')
set( gca, 'xdir', 'reverse' )
legend('\sigma_A=1, \sigma_B=1', '\sigma_A=1, \sigma_B=-1', '\sigma_A=-1, \sigma_B=1',...
    '\sigma_A=-1, \sigma_B=-1')
subplot(2, 2, 3)
plot(theta_deg, sign(N_A(1, :)), 'k-', theta_deg, sign(N_A(2, :)), 'b--', ...
    theta_deg, sign(N_A(3, :)), 'r:', theta_deg, sign(N_A(4, :)), 'g.-')
ylim([-1.5, 1.5])
xlim([0, 75]); xlabel('\theta (^o)'); 
set( gca, 'xdir', 'reverse' )
subplot(2, 2, 2)
plot(theta_deg, N_B(1, :), 'k-', theta_deg, N_B(2, :), 'b--', theta_deg, N_B(3, :), 'g-.', ...
    theta_deg, N_B(4, :), 'r.:')
xlim([0, 75]); xlabel('\theta (^o)'); ylabel('N_BL/mv^2')
set( gca, 'xdir', 'reverse' )
subplot(2, 2, 4)
plot(theta_deg, sign(N_B(1, :)), 'k.-', theta_deg, sign(N_B(2, :)), 'g-', ...
    theta_deg, sign(N_B(3, :)), 'b:', theta_deg, sign(N_B(4, :)), 'r--')
ylim([-1.5, 1.5])
xlim([0, 75]);  xlabel('\theta (^o)')
set( gca, 'xdir', 'reverse' )

vt_L = sin(beta - theta_deg * pi/180)/sin(beta);
figure(20)
subplot(2, 2, 1)
semilogy(vt_L, F(4, :), 'k-', vt_L, N_A(4, :), 'r--', vt_L, N_B(4, :), 'b:.')
% set( gca, 'xdir', 'reverse' )
ylim([1e-4, 1e+4]); ylabel('Forces'); xlabel('vt/L')
yticks([1e-4, 1e-2, 1, 1e+2, 1e+4])
subplot(2, 2, 2)
semilogy(theta_deg, F(4, :), 'k-')
set(gca, 'xdir', 'reverse' )
sigma_A = -1;
sigma_B = -1;
DD = @(theta) det([[1, -mu, (sigma_B * sin(beta) - mu * cos(beta))];
    [0,  sigma_A, (sigma_B * cos(beta) + mu * sin(beta))];
    [sin(theta), (sigma_A * cos(theta) - mu * sin(theta)), ...
    (-sigma_B * cos(beta - theta) - mu * sin(beta - theta))]]);
th=beta-[0:90]*pi/180;
for kk = 1: length(th)
    det_DD(kk) = det(DD(th(kk)));
end

figure(100)
plot(th*180/pi, det_DD)
xlabel('\theta'); ylabel('Determinant |DD|'); grid on
singular_th= fzero(DD, 0);
disp('Singular value of theta')
disp(singular_th * 180/pi)


