 % Linkage_energy_example
L = 0.8;
k = 9000;
m_AB = 40; m_A = 5; m_B = 5;
s_0 = 0.3;
g = 9.807;
delta = @(phi) s_0 - (L / sin(pi/3)) * sin(phi);
V = @(phi) 0.5 * k * delta(phi).^2 + (m * g/2 + m_A +m_B) * L * sin(phi);
v_A = @(phi, d_phi) d_phi * (L/sin(pi/3)) * cos(phi) ...
    * [cos(pi/3); sin(pi/3)];
v_B = @(phi, d_phi) d_phi * L * (sin(phi)- cot(pi/3) * cos(phi)) ...
    * [-1;  0];
v_G = @(phi, d_phi) 0.5 * (v_A(phi, d_phi) + v_B(phi, d_phi)); 
T_raw = @(phi, d_phi) 0.5 * m_AB * norm(v_G(phi, d_phi))^2 ...
    + 0.5 * (1/12) * m * L^2 * d_phi^2 + 0.5 * m_A * norm(v_A(phi, d_phi))^2 ...
    + 0.5 * m_B * norm(v_B(phi, d_phi))^2;
T = @(phi, d_phi) 0.5 * ((m_A + m_AB/4) *(4/3) * cos(phi).^2 ...
    +  (m_B + m_AB/4) * (4/3) * cos(phi + pi/3).^2 ...
    + m_AB * (1/3) * cos(phi) .* cos(phi + pi/3) + (1/12) * m_AB) * (L * d_phi).^2;

V = @(phi) 0.5 * k *(s_0 - L * sin(phi)/sin(pi/3)).^2 ...
    + (m_AB/2 + m_A) * g * L * sin(phi);

f = @(phi) V(phi) - V(0);
phi = [-90 : 90] * pi/180;
figure(10)
plot(phi, f(phi))
phi_a = fzero(f, 0.6)
phi_a * 180/pi

phi_b = phi_a - 5 * pi/180;
V_2 = V(phi_b) 
T_2_fac = T(phi_b, 1)
d_phi_2 = sqrt(V_2/T_2_fac)
