% Equation of Motion for a Falcon Rocket including gravity, aerodynamic
% drag with altitude dependent air density and variable mass of the rocket
% as fuel is expended.
% [Z_dot] = Falcon_Z_dot(Z, t, m_total, m_dot, C_d, g)
%
function [Z_dot] = Falcon_Z_dot(Z, t, m_total, m_dot, C_d, g)
Thrust = 6e6;
y = Z(1);
v = Z(2);
m_cv = m_total - m_dot * t;
inv_M_mat = [[1,  0]; [0,  1/m_cv]];
if g == 0
    a_grav = gravity(y);
else
    a_grav = g;
end
RHS = [v;  Thrust - resistance(y, v, C_d) - m_cv * a_grav];
Z_dot = inv_M_mat * RHS;
end

