% Squeeze_rack_accel
% Example 4.11
% Program that solves and graphs the velocity and acceleration of the contact points

clear all; close all

% Nondimensionalize by setting v and R equal to one
v = 1; 
R = 1;
v_fac = v/R;
a_fac = v^2/R;

theta = [1 : 89] * pi/180;
L = R * cot(theta/2);

v_A = v ./ (1 + cos(theta));
om_A = -v_fac * cos(theta) ./ (1 + cos(theta));
theta_dot = v_fac * (1 - cos(theta)) ./ (1 + cos(theta));
F_theta = sin(theta).^3 ./ (1 + cos(theta)).^4;

v_A_dot = v * F_theta;
om_A_dot = v_fac^2 * F_theta;
theta_2dot = 2 * v_fac^2 * F_theta;

for n = 1 : length(theta)
    th_n = theta(n);

    % Use XYZ components for contact at B
    v_A_XYZ(:, n) = v_A(n) * [-1; 0];
    v_B_gear(:, n) = v_A_XYZ(:, n) + om_A(n) * R * [1; 0];
    a_A_XYZ(:, n) =  v_A_dot(n) * [-1; 0];
    a_B_gear(:, n) = a_A_XYZ(:, n) + om_A_dot(n) * R * [1; 0] + om_A(n)^2 * R * [0; 1];

    % Use xyz components for contact at E
    v_A_xyz(:, n) = v_A(n) * [-cos(th_n); sin(th_n)];
    v_E_gear(:, n) = v_A_xyz(:, n) + om_A(n) * R * [-1; 0];
    v_E_CD(:, n) = L(n) * theta_dot(n) * [0; 1];
    a_A_xyz(:, n) =  v_A_dot(n) * [-cos(th_n); sin(th_n)];
    a_E_gear(:, n) = a_A_xyz(:, n) + om_A_dot(n) * R * [-1; 0] + om_A(n)^2 * R * [0; -1];
    a_E_CD(:, n) = L(n) * theta_2dot(n) * [0; 1] + L(n) * theta_dot(n)^2 * [-1; 0];
end

figure(10)

% Velocity of point B
subplot(3, 2, 1)
plot(theta * 180/pi, v_B_gear(1, :), 'r-', theta * 180/pi, v_B_gear(2, :), 'b--', 'linewidth', 1) 
ylim([-1.5, 0.5])
ylabel('v_B')

% Velocity of point E
subplot(3, 2, 2)
plot(theta * 180/pi, v_E_gear(1, :), 'r-', theta * 180/pi, v_E_CD(1, :), 'b--', ...
     theta * 180/pi, v_E_gear(2, :), 'r-', theta * 180/pi, v_E_CD(2, :), 'b--', 'linewidth', 1)
ylim([-0.5, 1])
ylabel('v_E')

% Acceleration of point B
subplot(3, 2, 3)
plot(theta * 180/pi, a_B_gear(1, :), 'r-', theta * 180/pi, a_B_gear(2, :), 'b--', 'linewidth', 1)
ylim([-0.1, 0.3])
ylabel('a_B')

% Acceleration of point E
subplot(3, 2, 4)
plot(theta * 180/pi, a_E_gear(1, :), 'r-', theta * 180/pi, a_E_CD(1, :), 'ko', ...
     theta * 180/pi, a_E_gear(2, :), 'b-', theta * 180/pi, a_E_CD(2, :), 'b--', ...
     'markersize', 1.5, 'linewidth', 1, 'markerindices', 1 : 4 : 89)
xlim([0, 90])

% Enhanced Plot Markers for Velocity B
subplot(3, 2, 1)
hold on
plot(theta * 180/pi, -ones(1, length(theta)), 'ro', 'linewidth', 1, ...
    'MarkerIndices', 1 : 6 : length(theta), 'MarkerSize', 2) 
plot(theta * 180/pi, zeros(1, length(theta)), 'bd', 'linewidth', 1, ...
    'MarkerIndices', 1 : 6 : length(theta), 'MarkerSize', 2) 
xlim([0, 90])
ylim([-1.5, 0.5])

% Enhanced Plot Markers for Velocity E
subplot(3, 2, 2)
hold on
plot(theta * 180/pi, v_E_CD(1, :), 'ro', 'linewidth', 1, ...
    'MarkerIndices', 1 : 6 : length(theta), 'MarkerSize', 2) 
plot(theta * 180/pi, v_E_CD(2, :), 'bd', 'linewidth', 1, ...
    'MarkerIndices', 1 : 6 : length(theta), 'MarkerSize', 2)

% Enhanced Plot Markers for Acceleration B
subplot(3, 2, 3)
hold on
plot(theta * 180/pi, zeros(1, length(theta)), 'ro', 'linewidth', 1, ...
    'MarkerIndices', 1 : 6 : length(theta), 'MarkerSize', 2)  
plot(theta * 180/pi, zeros(1, length(theta)), 'bd', 'linewidth', 1, ...
    'MarkerIndices', 4 : 6 : length(theta), 'MarkerSize', 2) 
xlim([0, 90])
xlabel('\theta (deg)')

% Evaluate theta vs time
figure(20)
theta_0 = 5; % deg
theta_t = [theta_0 : 89] * pi/180;

t_integrand = @(theta) (1 + cos(theta)) ./ (1 - cos(theta));
t(1) = 0;
for n = 2 : length(theta_t)
    t(n) = t(n - 1) + integral(t_integrand, theta_t(n - 1), theta_t(n));
end
X_B = cot(theta_t / 2);

subplot(3, 2, 1)
plot(t, theta_t * 180/pi, 'r', 'linewidth', 1)
xlabel('vt/R')
ylabel('\theta (deg)')
ylim([theta_0, 90])
yticks([5, 30, 60, 90])

subplot(3, 2, 3)
plot(X_B, t, 'r', 'linewidth', 1)
xlabel('X_B/R')
ylabel('vt/R')
