function [R] = simple_rotations(theta, axis_number)
if axis_number == 1
    R = [[1, 0, 0]; [0, cos(theta), sin(theta)]; [0, -sin(theta), cos(theta)]];
elseif axis_number == 2
    R = [[cos(theta), 0, -sin(theta)]; [0, 1, 0]; [sin(theta), 0, cos(theta)]];
elseif axis_number == 3
    R = [[cos(theta), sin(theta), 0]; [-sin(theta), cos(theta), 0]; [0, 0, 1]];
else
    disp('Error: axis_number must be 1, 2, or 3')
    return
end
    


