% Calculations for Section 3.5 on influence of Earth's motion on gravity
% NASA: https://solarsystem.nasa.gov/solar-system/sun/overview
close all; clear all
T_day = 23*3600+56*60+4.06
omega_spin = 2 * pi/T_day
T_orbit = 365.256 * T_day
omega_orbit = 2 * pi/T_orbit
R_orbit = 149.6e6 * 1000
v_orbit = omega_orbit * R_orbit % Orbitalspeed: km/hr to m/s
% Sun orbit parameters
T_sun_orbit = 230e6 *(365.25 * T_day); % Convert years to seconds for one orbit
omega_sun = 2 * pi/T_sun_orbit
v_sun_orbit = 720e3 * 1000
R_sun_orbit = v_sun_orbit/omega_sun
a_G_sun = omega_sun^2 * R_sun_orbit 
a_G_earth = omega_orbit^2 * R_orbit

G = 6.6743e-11;
M_sun = 1.9891e30;
m_earth = 5.97219e24;
R_e = 6371e3;
m = 1;
F_grav = G * m_earth * m/R_e^2
F_acc = m * R_e * omega_spin^2
frac = F_acc/F_grav
lambda_deg = [-90 : 90];
lambda = lambda_deg * pi/180;
mg_F_grav = ( 1 - frac * cos(lambda).^2);
chi = atan(frac * sin(lambda) .* cos(lambda));
chi_deg = chi * 180/pi;
figure(10)
yyaxis left
subplot(3, 1, 1)
plot(lambda_deg, mg_F_grav, '-r')
xlabel('\lambda (^o)'); ylabel('mg/F_{grav}')
yyaxis right
plot(lambda_deg, chi_deg, ':b')
xlabel('\lambda (^o)'); ylabel('\chi (^o)')

% Free fall shift
lambda_f = 0;
g = 9.807;
H = 1000;
y_f = -(1/3) * omega_spin * cos(lambda_f) * sqrt(32 * H^3/g)
    v_t = [0.25 : 0.01 : 1];
w_t = v_t/2;
psi = [-1 : 0.1: 1] * pi;
% psi = 0;
lambda = pi/3;
figure(20)
hold on
radius = max(v_t);
for n = 1 : length(psi)
    x(n, :) = (-radius + v_t) * cos(psi(n)) + w_t .* v_t * sin(lambda) * sin(psi(n));
    y(n, :) = (-radius + v_t) * sin(psi(n)) - w_t .* v_t * sin(lambda) * cos(psi(n));
    % x is north, graphed X is right;
    % y is west, graphed Y is up
    plot(x(n, :), y(n, :), '-k', 'linewidth', 1)
%     plot(xplot(n, :), yplot(n, :), '-k', 'linewidth', 1)
end
axis equal


