% Examples 5 and 6 in Chapter 3, Arbitrary Rotations
clear all

phi = -40 * pi/180;

L_Z_X = -0.4;
L_Z_Y = 0.3;
L_Z_Z = -sqrt(1 - L_Z_X^2 - L_Z_Y^2);
theta = acos(L_Z_Z);
psi = atan2(L_Z_Y/sin(theta), L_Z_X/sin(theta));

R_psi = [[cos(psi), sin(psi), 0]; [-sin(psi), cos(psi), 0]; [0, 0, 1]];
R_theta = [[cos(theta), 0, -sin(theta)]; [0, 1, 0]; [sin(theta), 0, cos(theta)]];
R_prime = R_theta * R_psi;
R_phi = [[cos(phi), sin(phi), 0]; [-sin(phi), cos(phi), 0]; [0, 0, 1]];
R = R_prime' * R_phi * R_prime;
K_prime = [L_Z_X, L_Z_Y, L_Z_Z]
[psi, theta]
[psi, theta] * 180/pi
R_prime
R_phi
R

disp(' ')
disp('Now work backward')
[vecs, eigens]=eig(R)
e_phi = vecs(:, 3)
theta_eq = acos(e_phi(3, 1));    
psi_eq = atan2(e_phi(2, 1)/sin(theta_eq), e_phi(1, 1)/sin(theta_eq));
[psi_eq, theta_eq] * 180/pi
R_psi_eq = [[cos(psi_eq), sin(psi_eq), 0]; [-sin(psi_eq), cos(psi_eq), 0]; [0, 0, 1]];
R_theta_eq = [[cos(theta_eq), 0, -sin(theta_eq)]; [0, 1, 0]; ...
    [sin(theta_eq), 0, cos(theta_eq)]];
R_prime_eq = R_theta_eq * R_psi_eq
% Find phi using transformation equation
R_phi_eq = R_prime_eq * R * R_prime_eq'
phi_eq = atan2(R_phi_eq(1, 2), R_phi_eq(1, 1));
% Compare to trace
cos_phi = (trace(R) - 1)/2;
phi_1 = acos(cos_phi);
phi_2 = -acos(cos_phi)
[phi, phi_eq, phi_1, phi_2] * 180/pi




