% Coriolis_vortex plot
clear all
close all
FF = 1;
om_rel = 1;
r_0 = 1;
t_max = 1.2;
t = [0 : 0.01 : 1] * t_max;
N_heads = 24;

psi = [0 : N_heads] * 2 * pi/N_heads;
x = @(t, psi) cos(psi) * (r_0 - 0.5 * FF * t.^2) ...
    - (1/3) * om_rel * FF * sin(psi) * t.^3;
y = @(t, psi) sin(psi) * (r_0 - 0.5 * FF * t.^2) ...
    + (1/3) * om_rel * FF * cos(psi) * t.^3;

figure(1)
hold on
for n = 1 : length(psi)
    xx = x(t, psi(n));
    yy = y(t, psi(n));
    % x is north, graphed X is right;
    % y is west, graphed Y is up
    % x axis is north (up) and y axis is west (left)
    plot(-yy, xx, '-k', 'linewidth', 1)
%     plot(xplot(n, :), yplot(n, :), '-k', 'linewidth', 1)
end
line([-r_0/4, 0, 0], [0, 0, r_0/4], 'linewidth', 1, 'color', 'black')
axis equal
xlim([-1.05 * r_0, 1.05 * r_0]) 
ylim([-1.05 * r_0, 1.05 * r_0]) 

axis equal


