function Z_dot = golf_eom(Z, t, c_m, g)
% State Space equations of motion for golf ball in flight.
%   Z_dot = golf_eom(Z, t, c_m, g)
% where c_m is the (c/m) constant and g is the gravitational constant.
% 
% The state vector Z = [q; q_dot] = [x; z; x_dot; z_dot]

% Decompose the input value of Z:
N = 2;
q = Z(1:N);
q_dot = Z(N+1:2*N);
% Right hand side of EOM
speed = norm(q_dot);
% State Space EOM (Eq. (7))
Z_dot = [q_dot;  
    - c_m * speed * q_dot + [0;  -g] ];
end

