% Function which determines the stretch ratios and unit vectors for a
% curvilinear coordinate system, per the discussion in the online
% supplement to Chapter 2.
%
% [E, h] = Curvi_vecs(r, phi, theta)
%
function [E, h] = Curvi_vecs(r, phi, theta)
    % Spherical coordinate properties
    cph = cos(phi);
    sph = sin(phi);
    cth = cos(theta);
    sth = sin(theta);
    %     J = [[sph * cth, sph * sth, cph];...
    %         [r * cph * cth, r * cph * sth, -r * sph];...
    %         [-r * sph * sth, r * sph * cth, 0]];
    % Numerical evaluation of Jacobian on spherical coords
        delta_ang = 1e-4;
    delta_r = 1;
    r_vec = @(r, phi, theta) [r * sin(phi) * cos(theta),...
    r * sin(phi) * sin(theta), r * cos(phi)];
    J = [(r_vec(r + delta_r, phi, theta)...
        - r_vec(r - delta_r, phi, theta))/(2 * delta_r); ...
        (r_vec(r, phi + delta_ang, theta)...
        - r_vec(r, phi - delta_ang, theta))/(2 * delta_ang);...
        (r_vec(r, phi, theta + delta_ang)...
        - r_vec(r, phi, theta - delta_ang))/(2 * delta_ang)];
    h_sq = J * J.';
    h_vals = sqrt(diag(h_sq));
    h = diag(h_vals);
    E = h\J;
end

