% Begin function that defines f(x,t)
function [xdot] = eom_rocket(t,x)
% Equations of motion for Rocket
m = 0.060; g = 9.81; % kg, m/s^2
F = 6.25*(t<1.6); % N (thrust)
% Note, drag calculation was as follows:
% c=(1/2)*C_D*Ap*rho_f = (1/2)*0.75*(0.025^2*pi/4)*1.2 = 2.2e-4 kg/m
c = 2.2e-4; % Kg/m
% matlab passes in values of x at time t
y = x(1); ydot = x(2);
% Equations of Motion
xdot(1,1) = ydot;
xdot(2,1) = F/m-g-(c/m)*ydot*abs(ydot);
end
