% Vector_algebra.m
% Define column vectors:
A = [1  2  3].';   
B = [3  -1  -5].';
% The skew function is stored somewhere in Matlab’s search path.
skew_A = skew(A) % Omission of the ; termination symbol will print to the command window
C = cross(A, B);
e_A = A/norm(A);  e_B = B/norm(B);  e_C = C/norm(C);
disp('e_A, e_B, e_C')
disp([e_A   e_B   e_C])
disp(' ') % Insert a blank line before the next expression.
Triple_dot = e_C.'*skew_A*B;  abs_C = norm(C);
disp(['A x B . e_C = ', num2str(Triple_dot), ',  |C| = ', num2str(abs_C)])
disp(' ')
Triple_1 = skew(skew_A * B) * C; Triple_2 = skew_A * skew(B) * C;
Triple_ident = (A.'* C) * B - (A.'* B) * C;
disp(' ')
disp(['(A x B) x C, A x (B x C), (A'' * C) * B-(A'' * B) * C'])
disp([Triple_1, Triple_2, Triple_ident])