%% Model_rocket_example.m
clear all
close all
% Initial Conditions
y0 = 0; ydot0 = 0;
[tout,xout] = ode45('eom_rocket',[0,10],[y0; ydot0]);

% Analytical solution (see text for derivation)
m = 0.060; g = 9.81; % Units kg, m/s^2
c = 2.2e-4; % Kg/m
kappa = sqrt((6.25 - m *g)/c);
lambda = sqrt((m *g)/c);
t_b = 1.6; % Burnout
F_b = 6.25; % Thrust
N_time = length(tout);
for j = 1 : N_time
    tt = tout(j);
    % Velocity prior to burnout
    if tt <= t_b
        vv(j) = kappa * tanh((kappa * c/m) * tt);
        acc(j) = (c/m) * (kappa^2 - vv(j)^2);
    else
        v_b = kappa * tanh((kappa * c/m) * t_b); % Velocity at burnout
        v_formula = lambda * tan(atan(v_b/lambda) - (lambda * c/m) * (tt - t_b));
        if v_formula >= 0 % Stop evaluation when upward motion ends
            % Rocket is continuing to ascend
            vv(j) = v_formula;
            acc(j) = -(c/m) * (lambda^2 + vv(j)^2);
        else
            % Stop evaluation when upward motion ends
            v_max = v_formula;
            N_pos = j - 1;
            break, break, break
        end
    end
end
tt = tout(1 : N_pos);
% Identify maxima
[v_max,  i_v_max] = max(vv)
t_max_v = tt(i_v_max)
[v_max_comp,  i_v_max_comp] = max(xout(:, 2))
t_max_v_comp = tt(i_v_max_comp)
y_max_comp = max(xout(:, 1))
t_max_y_comp = max(tt)
max_y = xout(N_pos, 2);
% Plot results
figure(1)
subplot(3,1,1)
plot(tout,xout(:,1),'k.-');
xlabel('Time (s)'); ylabel('Altitude y(t) (m)');
subplot(3,1,2)
plot(tout, xout(:,2), 'k.-', 'linewidth', 0.75);
hold on
plot(tt, vv, 'r:', 'linewidth', 1.5, 'markersize', 1.5);
ylim([-25  130])
hold on
plot(t_max_v, v_max, 'ro', 'markersize', 4)
xlabel('Time (s)'); ylabel('Velocity dy/dt (m/s)');
legend('Numerical', 'Analytical', 'Maximum y')
% Note, (3,1,3) left blank; this sizing used to easily get the correct
% proportions for these figures.

