function [X] = view_vecs(varargin);
% Display vectors of unequal length side by side.  Short vectors are padded
% with zeros so they can be inserted in a single matrix.
%
% [Vec_Matrix] = view_vecs(v1,v2,v3,v4,...);
%
% [Vec_Matrix] = view_vecs(v1,v2,v3,v4,...,'tab');
%   Displays the matrix in tab-delimited form - suitable for pasting into
%   Microsoft Excel.
% 
% The matrix is displayed if no outputs are requested.
%
% Matt Allen, June 2006
%

if ischar(varargin{end});
    nvecs = nargin-1;
    disp_mode = 'tab';
else
    nvecs = nargin;
    disp_mode = 'standard';
end

for k = 1:nvecs
    lvs(k) = length(varargin{k});
end

max_l = max(lvs);

X = zeros(max_l,nvecs);
for k = 1:nvecs
    X(:,k) = [vec(varargin{k}); zeros(max_l-lvs(k),1)];
end

if nargout < 1;
    if strcmp(disp_mode,'tab');
        for rind = 1:size(X,1);
            for cind = 1:size(X,2);
                fprintf('%g\t',X(rind,cind));
            end
            fprintf('\n');
        end
    else
        disp(X);
    end
end