function [] = sdaxset()
% X-axis Zoom for Stabilization Diagrams or other figures with multiple
% axes.  Bounds selected graphically or as input arguments are set for
% all axes (i.e. subplots or overlaid axes) simultaneously.
% 
% The first two left mouse clicks define a region to zoom into (based on the
% x-location only.)
%
% Subsequently:
%   - Middle Button Click - Allows one to zoom in again.  Select the new
%   upper and lower limits.
%   - Right Button Click - causes the stabilization diagram to zoom back out
%   (return to original axis limits.)
%
% Matt Allen, Created in 2004
% msalle@sandia.gov
%
% TO DO:  Combine this with sdaxsetb by providing an option here for permanent
% setting of axis limits.

disp('To Zoom in again, click the MIDDLE mouse button, then the new bounds');
disp('To quit and zoom back out, click the RIGHT mouse button.');

% Define Current Axis Properties
fig_num = gcf;
axhs = findall(gcf,'type','axes');
    % Remove Legend Entries - these are also type 'axes'
    axhs = axhs(find(~strcmp(get(axhs,'Tag'),'legend')));
    % Store old limits
    x_lim_old = get(axhs,'Xlim');
    y_lim_old = get(axhs,'Ylim');


% Set Limits once by default
[x_lims,y_lims] = ginput(2);
set(axhs,'Xlim',sort(x_lims));

	% Set Y-axis to original
	%for k = 1:length(axhs);
    %    set(axhs(k),'Ylim',y_lim_old{k});
    %end

    
% Zoom out if Right mouse button is depressed.  If the middle button is
% depressed, zoom in again.
loop_break = 0;
while loop_break == 0;
    [j1,j2,mbutton] = ginput(1);
    if mbutton == 3;
        loop_break = 1;
        % Reset to old limits
		for k = 1:length(axhs);
            set(axhs(k),'Xlim',x_lim_old{k});
		end
    elseif mbutton == 2;
        % Set New Axis limits
        [x_lims,y_lims] = ginput(2);
        set(axhs,'Xlim',sort(x_lims));
    end
end


    